/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.AxisCanvas;
import ibm.nways.jdm.AxisEvent;
import ibm.nways.jdm.AxisListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class JdmLayout
implements LayoutManager,
AxisListener {
    private Component navTree;
    private Component deviceGraphic;
    private Component destPanel;
    private Component banner;
    private Component footer;
    private AxisCanvas axis1;
    private AxisCanvas axis2;
    private static float[][] defaultFracts = new float[][]{{0.25f, 0.33f}, {0.25f, 0.75f}};
    private float[] fracts;
    private float[] constFracts;
    int axis1pos;
    int axis2pos;
    private int scheme;
    public static final int WIDE_SCHEME = 0;
    public static final int TALL_SCHEME = 1;
    public int horzAxisThickness = 16;
    public int vertAxisThickness = 16;

    public JdmLayout() {
        this.initDefaultSchemeFracts();
    }

    public JdmLayout(int n) {
        this.scheme = n;
        this.initDefaultSchemeFracts();
    }

    public void setScheme(int n) {
        this.scheme = n;
        this.initDefaultSchemeFracts();
        this.update();
    }

    public int getScheme() {
        return this.scheme;
    }

    public float[] getFracts() {
        return this.fracts;
    }

    public void setFracts(float[] fArray) {
        int n = fArray.length;
        this.fracts = new float[n];
        this.constFracts = new float[n];
        int n2 = 0;
        while (n2 < n) {
            this.fracts[n2] = fArray[n2];
            this.constFracts[n2] = this.fracts[n2];
            ++n2;
        }
    }

    private void initDefaultSchemeFracts() {
        this.axis1pos = 1;
        this.axis2pos = 2;
        this.setFracts(defaultFracts[this.scheme]);
    }

    public void addLayoutComponent(String string, Component component) {
        if ("NavTree".equals(string)) {
            this.navTree = component;
            return;
        }
        if ("DeviceGraphic".equals(string)) {
            this.deviceGraphic = component;
            return;
        }
        if ("DestPanel".equals(string)) {
            this.destPanel = component;
            return;
        }
        if ("Axis1".equals(string)) {
            this.axis1 = (AxisCanvas)component;
            this.axis1.addAxisListener(this);
            this.update();
            return;
        }
        if ("Axis2".equals(string)) {
            this.axis2 = (AxisCanvas)component;
            this.axis2.addAxisListener(this);
            this.update();
            return;
        }
        if ("Banner".equals(string)) {
            this.banner = component;
            return;
        }
        if ("Footer".equals(string)) {
            this.footer = component;
        }
    }

    private void update() {
        switch (this.scheme) {
            default: {
                if (this.axis1 != null) {
                    this.axis1.setOrientation(1);
                }
                if (this.axis2 == null) break;
                this.axis2.setOrientation(2);
                return;
            }
            case 1: {
                if (this.axis1 != null) {
                    this.axis1.setOrientation(1);
                }
                if (this.axis2 == null) break;
                this.axis2.setOrientation(1);
            }
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.navTree) {
            this.navTree = null;
            return;
        }
        if (component == this.deviceGraphic) {
            this.deviceGraphic = null;
            return;
        }
        if (component == this.destPanel) {
            this.destPanel = null;
            return;
        }
        if (component == this.axis1) {
            this.axis1.removeAxisListener(this);
            this.axis1 = null;
            return;
        }
        if (component == this.axis2) {
            this.axis2.removeAxisListener(this);
            this.axis2 = null;
            return;
        }
        if (component == this.banner) {
            this.banner = null;
            return;
        }
        if (component == this.footer) {
            this.footer = null;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        dimension.width = container.getSize().width - container.getInsets().left - container.getInsets().right;
        dimension.height = container.getSize().height - container.getInsets().top - container.getInsets().bottom;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        switch (this.scheme) {
            case 0: {
                this.layoutSchemeWide(container);
                return;
            }
            case 1: {
                this.layoutSchemeTall(container);
                return;
            }
        }
        this.layoutSchemeWide(container);
    }

    private void layoutSchemeWide(Container container) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.axis1 != null) {
            this.vertAxisThickness = this.axis1.getMinimumWidth();
        }
        if (this.axis2 != null) {
            this.horzAxisThickness = this.axis2.getMinimumHeight();
        }
        Insets insets = container.getInsets();
        int n9 = insets.top;
        int n10 = container.getBounds().height - insets.bottom;
        int n11 = insets.left;
        int n12 = container.getBounds().width - insets.right;
        int n13 = n12 - n11;
        int n14 = n10 - n9;
        if (this.banner != null && this.banner.isVisible()) {
            n8 = this.banner.getPreferredSize().height;
            this.banner.setBounds(n11, n9, n13, n8);
        } else {
            n8 = 0;
        }
        if (this.footer != null && this.footer.isVisible()) {
            n7 = this.footer.getPreferredSize().height;
            this.footer.setBounds(n11, n10 - n7, n13, n7);
        } else {
            n7 = 0;
        }
        if (this.navTree != null && this.navTree.isVisible()) {
            n6 = (int)(this.fracts[0] * (float)n13);
            n5 = n12 - this.vertAxisThickness;
            n6 = n6 > n5 ? n5 : n6;
            this.navTree.setBounds(n11, n9 + n8, n6, n14 - n8 - n7);
        } else {
            n6 = 0;
        }
        int n15 = n6 + n11;
        int n16 = n9 + n8;
        int n17 = this.vertAxisThickness;
        int n18 = n14 - n8 - n7;
        if (this.axis1 != null && this.navTree != null) {
            this.axis1.setBounds(n15, n16, n17, n18);
            if (!this.axis1.isVisible()) {
                this.axis1.setVisible(true);
            }
        } else if (this.axis1 != null) {
            this.axis1.setVisible(false);
        }
        if (this.deviceGraphic != null && this.deviceGraphic.isVisible()) {
            int n19 = (int)(this.fracts[1] * (float)(n14 - n8));
            n5 = n14 - n7 - n8 - this.horzAxisThickness;
            n19 = n19 > n5 ? n5 : n19;
            n4 = n15 + n17;
            n3 = n19 + n9 + n8;
            n2 = n12 - n4;
            n = this.horzAxisThickness;
            this.deviceGraphic.setBounds(n4, n9 + n8, n2, n19);
        } else {
            int n20 = 0;
            n4 = n15 + n17;
            n3 = n20 + n9 + n8;
            n2 = n12 - n4;
            n = this.horzAxisThickness;
        }
        if (this.axis2 != null && this.deviceGraphic != null) {
            this.axis2.setBounds(n4, n3, n2, n);
            if (!this.axis2.isVisible()) {
                this.axis2.setVisible(true);
            }
        } else if (this.axis2 != null) {
            this.axis2.setVisible(false);
        }
        if (this.destPanel != null && this.destPanel.isVisible()) {
            n5 = n3 + n;
            this.destPanel.setBounds(n4, n5, n2, n10 - n5 - n7);
        }
    }

    private void dumpAllPrefs(Component component) {
        System.out.println("Preferred size of " + component + " is " + component.getPreferredSize());
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.dumpAllPrefs(componentArray[n]);
                ++n;
            }
        }
    }

    private void layoutSchemeTall(Container container) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        this.fracts[0] = this.determineFract(container, this.axis1pos, 1);
        this.fracts[1] = this.determineFract(container, this.axis2pos, 2);
        if (this.axis1 != null) {
            this.vertAxisThickness = this.axis1.getMinimumWidth();
        }
        Insets insets = container.getInsets();
        int n10 = insets.top;
        int n11 = container.getBounds().height - insets.bottom;
        int n12 = insets.left;
        int n13 = container.getBounds().width - insets.right;
        int n14 = n13 - n12;
        int n15 = n11 - n10;
        if (this.banner != null && this.banner.isVisible()) {
            n9 = this.banner.getPreferredSize().height;
            this.banner.setBounds(n12, n10, n14, n9);
        } else {
            n9 = 0;
        }
        if (this.footer != null && this.footer.isVisible()) {
            n8 = this.footer.getPreferredSize().height;
            this.footer.setBounds(n12, n11 - n8, n14, n8);
        } else {
            n8 = 0;
        }
        if (this.navTree != null && this.navTree.isVisible()) {
            n7 = (int)(this.fracts[0] * (float)n14);
            n6 = this.axis2 == null || this.deviceGraphic == null ? n13 - this.vertAxisThickness : n13 - this.vertAxisThickness * 2;
            n7 = n7 > n6 ? n6 : n7;
            this.navTree.setBounds(n12, n10 + n9, n7, n15 - n9 - n8);
        } else {
            n7 = 0;
        }
        int n16 = n7 + n12;
        int n17 = n10 + n9;
        int n18 = this.vertAxisThickness;
        int n19 = n15 - n9 - n8;
        if (this.axis1 != null && this.navTree != null) {
            this.axis1.setBounds(n16, n17, n18, n19);
            if (!this.axis1.isVisible()) {
                this.axis1.setVisible(true);
            }
        } else if (this.axis1 != null) {
            this.axis1.setVisible(false);
        }
        if (this.deviceGraphic != null && this.deviceGraphic.isVisible()) {
            n5 = (int)(this.fracts[1] * (float)n14);
            int n20 = n5 = n7 + this.vertAxisThickness > n5 ? n7 + this.vertAxisThickness : n5;
            if (this.axis2 != null && this.deviceGraphic != null) {
                n5 = n5 > n13 - this.vertAxisThickness ? n13 - this.vertAxisThickness : n5;
            }
            n4 = n5 + n12;
            n3 = n10 + n9;
            n2 = this.vertAxisThickness;
            n = n15 - n9 - n8;
            this.deviceGraphic.setBounds(n4 + n2, n3, n13 - n4 - n2, n);
        } else {
            n5 = n14 - this.vertAxisThickness;
            n4 = n5 + n12;
            n3 = n10 + n9;
            n2 = this.vertAxisThickness;
            n = n15 - n9 - n8;
        }
        if (this.axis2 != null && this.deviceGraphic != null) {
            this.axis2.setBounds(n4, n3, n2, n);
            if (!this.axis2.isVisible()) {
                this.axis2.setVisible(true);
            }
        } else if (this.axis2 != null) {
            this.axis2.setVisible(false);
        }
        if (this.destPanel != null && this.destPanel.isVisible()) {
            n6 = this.vertAxisThickness;
            if (this.axis2 == null || this.deviceGraphic == null) {
                n6 = 0;
            }
            this.destPanel.setBounds(n16 + n18, n3, n5 - n7 - n6, n);
        }
    }

    private void adjustAxis(AxisEvent axisEvent) {
        switch (this.scheme) {
            case 0: {
                this.adjustWideScheme(axisEvent);
                return;
            }
            case 1: {
                this.adjustTallScheme(axisEvent);
                return;
            }
        }
        this.adjustWideScheme(axisEvent);
    }

    private void adjustWideScheme(AxisEvent axisEvent) {
        Component component = axisEvent.getComponent();
        Container container = component.getParent();
        Insets insets = container.getInsets();
        int n = insets.top;
        int n2 = container.getBounds().height - insets.bottom;
        int n3 = insets.left;
        int n4 = container.getBounds().width - insets.right;
        Rectangle rectangle = component.getBounds();
        int n5 = this.banner != null && this.banner.isVisible() ? this.banner.getPreferredSize().height : 0;
        if (component == this.axis1) {
            float f;
            int n6 = rectangle.x + axisEvent.getX();
            this.fracts[0] = f = (float)(n6 - n3) / (float)(n4 - n3);
            this.constFracts[0] = this.fracts[0];
        } else {
            int n7 = rectangle.y + axisEvent.getY();
            float f = (float)(n7 - n - n5) / (float)(n2 - n - n5);
            this.fracts[1] = f = f < 0.0f ? 0.0f : f;
            this.constFracts[1] = this.fracts[1];
        }
        container.invalidate();
        container.validate();
    }

    private void adjustTallScheme(AxisEvent axisEvent) {
        Component component = axisEvent.getComponent();
        Container container = component.getParent();
        Insets insets = container.getInsets();
        container.getBounds();
        int n = insets.left;
        int n2 = container.getBounds().width - insets.right;
        Rectangle rectangle = component.getBounds();
        int n3 = rectangle.x + axisEvent.getX();
        float f = (float)(n3 - n) / (float)(n2 - n);
        if (component == this.axis1) {
            f = this.fracts[1] > f ? f : this.fracts[1];
            float f2 = (float)this.vertAxisThickness / (float)(n2 - n);
            this.fracts[0] = f + f2;
            this.constFracts[0] = this.fracts[0];
        } else {
            this.fracts[1] = f = this.fracts[0] < f ? f : this.fracts[0];
            this.constFracts[1] = this.fracts[1];
        }
        container.invalidate();
        container.validate();
    }

    public void axisShiftNegative(AxisEvent axisEvent) {
        Component component = axisEvent.getComponent();
        Container container = component.getParent();
        if (component == this.axis1) {
            int n = this.axis1pos = this.axis1pos == 0 ? 0 : this.axis1pos - 1;
        }
        if (component == this.axis2) {
            int n = this.axis2pos = this.axis2pos == 0 ? 0 : this.axis2pos - 1;
            if (this.scheme == 1) {
                int n2 = this.axis1pos = this.axis1pos > this.axis2pos ? this.axis2pos : this.axis1pos;
            }
        }
        if (this.scheme == 0 || this.deviceGraphic == null) {
            if (this.axis1pos == 2) {
                this.axis1pos = 1;
            }
            if (this.axis2pos == 1) {
                this.axis2pos = 0;
            }
        }
        this.fracts[0] = this.determineFract(container, this.axis1pos, 1);
        this.fracts[1] = this.determineFract(container, this.axis2pos, 2);
        ((Component)container).invalidate();
        ((Component)container).validate();
    }

    public void axisShiftPositive(AxisEvent axisEvent) {
        Component component = axisEvent.getComponent();
        Container container = component.getParent();
        if (component == this.axis2) {
            int n = this.axis2pos = this.axis2pos == 3 ? 3 : this.axis2pos + 1;
        }
        if (component == this.axis1) {
            int n = this.axis1pos = this.axis1pos == 3 ? 3 : this.axis1pos + 1;
            if (this.scheme == 1) {
                int n2 = this.axis2pos = this.axis1pos > this.axis2pos ? this.axis1pos : this.axis2pos;
            }
        }
        if (this.scheme == 0 || this.deviceGraphic == null) {
            if (this.axis1pos == 2) {
                this.axis1pos = 3;
            }
            if (this.axis2pos == 1) {
                this.axis2pos = 2;
            }
        }
        this.fracts[0] = this.determineFract(container, this.axis1pos, 1);
        this.fracts[1] = this.determineFract(container, this.axis2pos, 2);
        ((Component)container).invalidate();
        ((Component)container).validate();
    }

    private float determineFract(Container container, int n, int n2) {
        float f = 0.0f;
        if (this.scheme == 1) {
            Insets insets = container.getInsets();
            int n3 = insets.left;
            int n4 = container.getBounds().width - insets.right;
            f = (float)this.vertAxisThickness / (float)(n4 - n3);
        }
        float f2 = 0.0f;
        switch (n) {
            case 0: {
                f2 = 0.0f;
                break;
            }
            case 1: {
                f2 = this.constFracts[0];
                if (n2 != 1 || this.scheme != 1) break;
                f2 -= f;
                break;
            }
            case 2: {
                f2 = this.constFracts[1];
                if (n2 != 1 || this.scheme != 1) break;
                f2 -= f;
                break;
            }
            case 3: {
                f2 = 1.0f;
                break;
            }
        }
        return f2;
    }

    public void axisDragged(AxisEvent axisEvent) {
    }

    public void axisDropped(AxisEvent axisEvent) {
        Component component = axisEvent.getComponent();
        if (this.axis1 == component) {
            this.axis1pos = 1;
        } else if (this.axis2 == component) {
            this.axis2pos = 2;
        }
        this.adjustAxis(axisEvent);
    }
}

